<?php
// --- 1. CONFIGURAÇÕES FIXAS (Autoridades e Localização) ---
const DIRECTOR_NOME = 'JORGE JOAQUIM MANECO';
const MUNICIPAL_EDUCACAO = 'DIREÇÃO MUNICIPAL DA EDUCAÇÃO DE BENGUELA';
const LOCAL_DATA_FIXA = 'DIRECÇÃO MUNICIPAL DA EDUCAÇÃO DE BENGUELA, AOS ';
const DATA_ATUAL = '07 DE OUTUBRO DE 2025'; 

// --- 2. DADOS SIMULADOS DE FUNCIONÁRIOS (Substituir por busca no BD) ---
// Estes dados foram criados a partir dos snippets dos documentos que você forneceu.
$funcionarios = [
    1 => [
        'id' => 1,
        'nome' => 'Octávio Laurindo Baptista',
        'bi' => '002925753BA032',
        'data_bi' => '09/03/2018',
        'categoria' => 'Professor do Ensino Primário e Secundário do 6º Grau',
        'agente' => '11740119',
        'salario_liq' => '252.695,10',
        'salario_extenso' => '(Duzentos e Cinquenta e Dois mil e Seiscento e Noventa e Cinco Kwanzas, Dez Cêntimo)',
        'escola' => MUNICIPAL_EDUCACAO, // Direcção Municipal
        'iban' => 'AO06.0000.0000.0000.0000.0000.00',
        'ano_inicio' => '1995',
        'ano_fim' => date('Y'),
        'total_anos' => (int)date('Y') - 1995,
        'data_inicio_completa' => '15 de Janeiro de 1995',
        'razao_declaracao' => 'Funcionário em Pleno Exercício',
    ],
    2 => [
        'id' => 2,
        'nome' => 'Maria Rita',
        'bi' => '001234567LA001',
        'data_bi' => '01/01/2010',
        'categoria' => 'Professor do Ensino Primário e Secundário do 10º Grau',
        'agente' => '11275384',
        'salario_liq' => '350.000,00',
        'salario_extenso' => '(Trezentos e Cinquenta mil Kwanzas)',
        'escola' => 'Complexo Escola BG-1066- Tchipiandalo',
        'iban' => 'AO06.0010.0452.0040.3434.0116.3',
        'ano_inicio' => '2005',
        'ano_fim' => date('Y'),
        'total_anos' => (int)date('Y') - 2005,
        'data_inicio_completa' => '05 de Março de 2005',
        'razao_declaracao' => 'Funcionário em Pleno Exercício',
    ],
    3 => [
        'id' => 3,
        'nome' => 'Euridice Vanda Trindade Saraiva',
        'bi' => '009876543BA001',
        'data_bi' => '16/05/2010',
        'categoria' => 'Professor do Ensino Primário e Secundário do 3º Grau',
        'agente' => '07685225',
        'salario_liq' => '400.000,00',
        'salario_extenso' => '(Quatrocentos mil Kwanzas)',
        'escola' => 'Escola Primária BG 1327 – Deolinda Rodrigues',
        'iban' => 'AO06.0000.0000.0000.0000.0000.00',
        'ano_inicio' => '1981',
        'ano_fim' => '1993',
        'total_anos' => 'Doze',
        'data_inicio_completa' => '01 de Janeiro de 1981',
        'razao_declaracao' => 'Ex-Funcionário',
    ],
    4 => [
        'id' => 4,
        'nome' => 'Funcionário Falecido Exemplo (Pensão)',
        'bi' => '000000000XX000',
        'data_bi' => '00/00/0000',
        'categoria' => 'Professor do Ensino Primário e Secundário do 13º Grau',
        'agente' => '00000000',
        'salario_liq' => '500.000,00',
        'salario_extenso' => '(Quinhentos mil Kwanzas)',
        'escola' => 'Complexo Escolar BG 1065 do Calomburaco',
        'iban' => 'AO06.0000.0000.0000.0000.0000.00',
        'ano_inicio' => '1993',
        'ano_fim' => '2021',
        'total_anos' => '28',
        'data_inicio_completa' => '11 de Novembro de 1993',
        'razao_declaracao' => 'Falecido',
    ],
];


// --- 3. DEFINIÇÃO DOS MODELOS DE DOCUMENTOS ---
$documentos = [
    'residencia' => [
        'nome' => 'Declaração de Aquisição de Residência',
        'finalidade' => 'aquisição de uma residência junto ao Fundo de Fomento Habitacional',
        'template' => '
            <p><strong>DECLARAÇÃO DE EFECTIVIDADE</strong></p>
            <p>{{DIRECTOR}} , Director Municipal de Educação, declara para efeitos de {{FINALIDADE}}, que o(a) Senhor(a) **{{NOME}}**, é funcionário(a) do Ministério da Educação, colocado(a) no(a) {{ESCOLA}}, portador(a) do B.I nº **{{BI}}**, passado pelo Arquivo de Identificação de Benguela aos **{{DATA_BI}}**, com a categoria de **{{CATEGORIA}}**, agente nº **{{AGENTE}}**, auferindo um salário líquido mensal de AOA **{{SALARIO_LIQ}}** {{SALARIO_EXTENSO}}.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente Declaração, que vai por mim assinada e autenticada com o Carimbo a óleo em uso nesta Direcção Municipal de Educação.</p>
        ',
    ],
    'tempo_servico' => [
        'nome' => 'Declaração de Contagem de Tempo de Serviço',
        'finalidade' => 'contagem de tempo de serviço',
        'template' => '
            <p><strong>DECLARAÇÃO DE EFECTIVIDADE</strong></p>
            <p>{{DIRECTOR}} , Director Municipal de Educação, declara para efeitos de {{FINALIDADE}}, que o(a) Senhor(a) **{{NOME}}**, foi funcionário(a) do Ministério da Educação em efectivo serviço, controlado(a) por esta Direcção Municipal de Educação, no período de **{{ANO_INICIO_EXT}}** à **{{ANO_FIM_EXT}}** (Ajuste o texto por extenso), totalizando **{{TOTAL_ANOS}}** anos de serviço.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente Declaração, que vai por mim assinada e autenticada com o Carimbo a óleo em uso nesta Direcção Municipal de Educação.</p>
        ',
    ],
    'mudanca_banco' => [
        'nome' => 'Declaração de Mudança de Banco',
        'finalidade' => 'mudança de Banco para domiciliação dos salários',
        'template' => '
            <p><strong>DECLARAÇÃO DE EFECTIVIDADE</strong></p>
            <p>{{DIRECTOR}} , Director Municipal de Educação, declara para efeitos de {{FINALIDADE}}, que o(a) Senhor(a) **{{NOME}}**, com a categoria de **{{CATEGORIA}}**, agente nº **{{AGENTE}}**, funcionário(a) colocado(a) no(a) **{{ESCOLA}}** com a conta bancária com IBAN n.º **{{IBAN}}**.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente Declaração, que vai por mim assinada e autenticada com o Carimbo a óleo em uso nesta Direcção Municipal de Educação.</p>
        ',
    ],
    'subsidio_morte' => [
        'nome' => 'Declaração de Subsídio de Morte (Pensão)',
        'finalidade' => 'obtenção de pensão alimentar dos menores sobrevivos de {{NOME}}',
        'template' => '
            <p><strong>DECLARAÇÃO DE EFECTIVIDADE</strong></p>
            <p>{{DIRECTOR}} , Director Municipal de Educação, declara para efeitos de {{FINALIDADE}}, que este foi funcionário do Sector da Educação, colocado no {{ESCOLA}} com a categoria de **{{CATEGORIA}}**, tendo iniciado suas funções aos **{{DATA_INICIO_COMPLETA}}**, atividade que exerceu até o ano de **{{ANO_FIM}}**, totalizando **{{TOTAL_ANOS}}** anos de efetivo serviço.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente Declaração, que vai por mim assinada e autenticada com o Carimbo a óleo em uso nesta Direcção Municipal de Educação.</p>
        ',
    ],
];

// --- 4. LÓGICA DE GERAÇÃO DINÂMICA ---
$user_id = (int)($_GET['user'] ?? 0);
$template_id = $_GET['doc'] ?? null;
$funcionario_selecionado = $funcionarios[$user_id] ?? null;

$documento_final = null;
$nome_documento = 'Selecione um funcionário e um documento';

if ($funcionario_selecionado && $template_id && isset($documentos[$template_id])) {
    $doc_info = $documentos[$template_id];
    $nome_documento = $doc_info['nome'];
    $template = $doc_info['template'];

    // Mapeamento dos dados do funcionário para os placeholders
    $placeholders = [
        '{{DIRECTOR}}' => DIRECTOR_NOME,
        '{{FINALIDADE}}' => $doc_info['finalidade'],
        '{{NOME}}' => $funcionario_selecionado['nome'],
        '{{BI}}' => $funcionario_selecionado['bi'],
        '{{DATA_BI}}' => $funcionario_selecionado['data_bi'],
        '{{CATEGORIA}}' => $funcionario_selecionado['categoria'],
        '{{AGENTE}}' => $funcionario_selecionado['agente'],
        '{{SALARIO_LIQ}}' => $funcionario_selecionado['salario_liq'],
        '{{SALARIO_EXTENSO}}' => $funcionario_selecionado['salario_extenso'],
        '{{ESCOLA}}' => $funcionario_selecionado['escola'],
        '{{IBAN}}' => $funcionario_selecionado['iban'],
        // Adaptação para declaração de Tempo de Serviço (precisa de texto por extenso)
        '{{ANO_INICIO_EXT}}' => 'Mil Novecentos e ' . ($funcionario_selecionado['ano_inicio'] ?? 'XX'),
        '{{ANO_FIM_EXT}}' => 'Mil Novecentos e ' . ($funcionario_selecionado['ano_fim'] ?? 'XX'),
        '{{TOTAL_ANOS}}' => $funcionario_selecionado['total_anos'],
        '{{DATA_INICIO_COMPLETA}}' => $funcionario_selecionado['data_inicio_completa'],
    ];

    // Substituição dos placeholders no template
    $documento_final = str_replace(array_keys($placeholders), array_values($placeholders), $template);

    // Ajuste final para Subsídio de Morte, se necessário, substituindo o NOME na finalidade
    if ($template_id === 'subsidio_morte') {
        $documento_final = str_replace('{{NOME}}', $funcionario_selecionado['nome'], $documento_final);
    }
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerador de Documentos RH - Dinâmico</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
    <style>
        .declaration-content p {
            margin-bottom: 1rem;
            line-height: 1.6;
            text-align: justify;
        }
        .declaration-content strong {
            display: block;
            text-align: center;
            margin-bottom: 2rem;
        }
        @media print {
            .no-print { display: none !important; }
            .print-area { box-shadow: none; border: none !important; padding: 0 !important; margin: 0; }
            body { padding: 0 !important; margin: 0 !important; font-family: 'Times New Roman', Times, serif; }
        }
    </style>
</head>
<body class="bg-gray-50 font-sans">

    <div class="flex h-screen">
        
        <div class="no-print w-96 bg-gray-800 text-white p-6 shadow-2xl flex-shrink-0 overflow-y-auto">
            <h2 class="text-2xl font-bold mb-6 border-b border-gray-700 pb-3">Funcionários</h2>
            <ul class="space-y-4">
                <?php foreach ($funcionarios as $func): ?>
                    <li class="bg-gray-700 rounded-lg p-3 shadow-md">
                        <a href="?user=<?= $func['id'] ?>" 
                           class="block text-lg font-semibold hover:text-blue-400 transition <?= $user_id === $func['id'] ? 'text-blue-400' : 'text-white' ?>">
                            <i class="fas fa-user-circle mr-2"></i> <?= htmlspecialchars($func['nome']) ?>
                        </a>
                        <p class="text-sm text-gray-400 ml-5"><?= $func['categoria'] ?></p>

                        <?php if ($user_id === $func['id']): ?>
                            <div class="mt-3 ml-4 border-t border-gray-600 pt-3 space-y-2">
                                <h4 class="font-bold text-gray-300">Documentos:</h4>
                                <?php foreach ($documentos as $doc_id => $doc): ?>
                                    <a href="?user=<?= $func['id'] ?>&doc=<?= $doc_id ?>" 
                                       class="block text-sm p-2 rounded hover:bg-gray-600 transition <?= $template_id === $doc_id ? 'bg-blue-600 font-semibold' : 'bg-gray-700' ?>">
                                        <i class="fas fa-file-alt mr-2"></i> <?= htmlspecialchars($doc['nome']) ?>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>

        <div class="flex-1 overflow-y-auto p-8">
            <h1 class="text-3xl font-bold text-gray-800 mb-4">Documentos de Recursos Humanos</h1>
            
            <p class="text-gray-500 mb-8">
                <?= $funcionario_selecionado ? "Funcionário Selecionado: <strong>{$funcionario_selecionado['nome']}</strong>" : 'Selecione um funcionário na lista à esquerda.' ?>
            </p>
            
            <?php if ($documento_final): ?>
                
                <div class="flex justify-between items-center mb-6 no-print">
                    <h2 class="text-2xl font-semibold text-blue-900 border-b pb-2"><?= htmlspecialchars($nome_documento) ?></h2>
                    <button onclick="window.print()" class="bg-green-600 text-white px-6 py-2 rounded-lg hover:bg-green-700 transition">
                        <i class="fas fa-print"></i> Imprimir Documento
                    </button>
                </div>

                <div class="print-area bg-white p-12 lg:p-16 rounded-xl shadow-2xl border border-gray-300 w-full max-w-4xl mx-auto">
                    
                    <div class="text-center mb-10">
                        <p class="text-sm">REPÚBLICA DE ANGOLA</p>
                        <p class="text-sm">GOVERNO PROVINCIAL DE BENGUELA</p>
                        <p class="text-sm font-semibold mb-4"><?= MUNICIPAL_EDUCACAO ?></p>
                        <hr class="w-1/3 mx-auto mb-6 border-t-2 border-gray-400">
                    </div>

                    <div id="declaration-preview" class="declaration-content min-h-[500px]">
                        <?= $documento_final ?>
                    </div>

                    <div class='mt-12 text-right'>
                        <p><?= LOCAL_DATA_FIXA . DATA_ATUAL ?></p>
                    </div>
                    <div class='text-center mt-12'>
                        <p>O DIRECTOR MUNICIPAL</p>
                        <p class='font-bold mt-16'><?= DIRECTOR_NOME ?></p>
                    </div>
                </div>
            
            <?php else: ?>
                <div class="text-center p-20 bg-white rounded-xl shadow-lg">
                    <h2 class="text-2xl text-gray-600">Selecione um funcionário e, em seguida, um documento para gerar.</h2>
                    <p class="text-gray-400 mt-4">Os dados serão preenchidos automaticamente no modelo.</p>
                </div>
            <?php endif; ?>

        </div>
    </div>

</body>
</html>